# -*- coding: utf-8 -*-
from ladon.ladonizer import ladonize
from mysite.pywebsv.utils import request_valid, stamp2datetime, datetime2stamp, online_employee, get_hr_min, \
    SUCCESS_CODE, MESSAGE_CODE, SYSTEM_EXCEPTION, DATA_EXCEPTION, interface_response, user_photo, WEEKDAY, format_date
import json
from django.utils.translation import ugettext_lazy as _


class BioTimeAppAttendance(object):

    """
    【Attendance】考勤
    """

    @request_valid
    @ladonize(int, str, str, str, rtype=str)
    def date(self, source, device_token, language, token):
        """
        获取日期选项列表
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:返回请求结果
            请求成功
                {"code":1, "error":"", "describe":"", "message":"", "data": [{"code":值,"name":"显示名称"}]}
                code = 1 时，为用户自定义
            请求失败
                {"code":-10001, "error":"", "describe":"", "message":"弹窗信息", "data": ""}
        """
        data = [
            {'code': 2, 'name': u'{0}'.format(_(u'今天'))},
            {'code': 3, 'name': u'{0}'.format(_(u'昨天'))},
            {'code': 4, 'name': u'{0}'.format(_(u'这星期'))},
            {'code': 5, 'name': u'{0}'.format(_(u'上星期'))},
            {'code': 6, 'name': u'{0}'.format(_(u'这个月'))},
            {'code': 7, 'name': u'{0}'.format(_(u'上个月'))},
            {'code': 1, 'name': u'{0}'.format(_(u'自定义'))},
        ]
        return interface_response(SUCCESS_CODE, json.dumps(data), '', '')

    @request_valid
    @ladonize(str, str, str, int, long, long, int, int, str, str, str, rtype=str)
    def pull_attendance(self, search_item, pin, department, date, start, end, page_num, source, device_token, language, token):
        """
        获取考勤记录
        @param search_item:     查询条件(工号/姓名), 暂无用, 传空值
        @param pin:             工号, 1：Attendance -> My Attendance（上传人员工号, 接口返回考勤数据），2：Attendance -> Staff Attendance(工号为空，接口返回人员列表)
        @param department:　    部门,用 ， 连接
        @param date:            日期（1， 2， 3， 4， 5， 6， 7）， 1 固定为员工User Defined（自定义）选项，选择 User Defined（自定义）时Start(开始日期)和End(结束日期)不能为空
        @param page_num:        页码（每页15条）
        @param start:           开始日期（stamp）
        @param end:             结束日期（stamp）
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:返回请求结果
            请求成功
                {"code":1,"error":"","describe":"","message":"","data":[{"weekday":"星期","date":"日期","clock_in":"签到时间(stamp)","in_describe":"clock_in=0时显示该值(string)","clock_out":"签退时间(stamp)","out_describe":"clock_out=0时显示该值(string)","total_describe":"工作时间显示标题","total":"工作时间(00:00)"}]}
            请求失败
                {"code":-10001, "error":"", "describe":"", "message":"弹窗信息", "data": ""}
        """
        from mysite.personnel.models.model_emp import format_pin
        from mysite.sql_utils import get_sql, p_query
        from mysite.pywebsv.utils import date_period
        import datetime
        now = datetime.datetime.now().date()
        if date in (1, ): #User defined
            start = stamp2datetime(start)
            end = stamp2datetime(end) + datetime.timedelta(days=1)
        else:
            start, end = date_period(date, now)
        pin = pin.strip()
        data = []
        try:
            params = {
                'start': format_date(start),
                'end': format_date(end)
            }
            if not pin:
                search_item = search_item.strip()
                search = ''
                if search_item:
                    search = "  and (u.badgenumber like N'%%%s%%' or u.name like N'%%%s%%') "
                if department:
                    search += " and u.defaultdeptid in ({0})".format(department)
                params['and'] = search
                sql = get_sql('sql', sqlid='attendance_employee', app="pywebsv", params=params)
                rows = p_query(sql)
                if rows:
                    data = [{'pin': r[0], 'name': r[1], 'photo': user_photo(r[0])} for r in rows]
            else:
                pin = format_pin(pin)
                params['pin'] = pin
                sql = get_sql('sql', sqlid='attendance', app="pywebsv", params=params)
                rows = p_query(sql)
                if rows:
                    for r in rows:
                        check_in = r[2]
                        check_out = r[3]
                        if r[2] == r[3]:
                            check_out = 0
                        if check_in in (None, '', 'None', datetime.datetime(1900, 1, 1)):
                            check_in = 0
                        if check_out in (None, '', 'None', datetime.datetime(1900, 1, 1)):
                            check_out = 0
                        total = 0
                        if check_in and check_out and check_out > check_in:
                            delta = check_out - check_in
                            total = delta.days * 24 * 60 * 60 + delta.seconds
                        if check_in:
                            check_in = datetime2stamp(check_in)
                        if check_out:
                            check_out = datetime2stamp(check_out)
                        date = (datetime.datetime.strptime(r[1], '%Y-%m-%d'))
                        item = {
                            'weekday': u'{0}'.format(WEEKDAY.get(date.weekday())),
                            'date': datetime2stamp(date),
                            'clock_in': check_in,
                            'in_describe': 'N/A',
                            'clock_out': check_out,
                            'out_describe': 'N/A',
                            'total_describe': 'WorkTime',
                            'total': get_hr_min(total),
                            'data_type': 1,
                            'describe': ''
                        }
                        data.append(item)
            return interface_response(SUCCESS_CODE, json.dumps(data), '', '')
        except Exception, e:
            import traceback
            traceback.print_exc()
            return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)

